/***********************************************************************
   Xpress Optimizer Examples
   =========================

   file MipSolPool.cs
   ``````````````````
   Generate all solutions with the MIP solution pool

   We take the power generation problem stored in hpw15.mps which seeks to
   optimise the operating pattern of a group of electricity generators. We
   solve the problem collecting all solutions found during the MIP search.
   The optimal solution's objective and solution values are printed to
   screen.

   (c) 2008-2025 Fair Isaac Corporation
********************************************************************/

using System;
using System.IO;
using Optimizer;

namespace XPRSExamples
{
    class MipSolPool
    {
        public static void Main(string[] args)
        {
            XPRS.Init();

            XPRSprob prob = new XPRSprob();
            prob.AddMsgHandlerCallback(Console.Out);

            XPRSmipsolpool msp = new XPRSmipsolpool();

            msp.ProbAttach(prob);

            prob.MPSFormat = -1;
            prob.ReadProb("hpw15");

            prob.Optimize();

            int nSols = msp.Solutions;

            if (nSols > 0)
            {
                int iSolutionId, iSolutionIdStatus;
                double dObj;
                msp.GetDblAttribProbExtreme(prob, 0, out iSolutionId, (int)XPRSattribute.Msp_SolPrb_Obj, out dObj);

                Console.WriteLine("Optimal Solution ID: " + iSolutionId);
                Console.WriteLine("Optimal Objective  : " + dObj);

                int nCols = msp.GetIntAttribSol(iSolutionId, out iSolutionIdStatus, (int)XPRSattribute.Msp_Sol_Cols);
                for (int i = 0; i < nCols; i++)
                {
                    int nValuesReturned;
                    double[] dSol = new double[1];
                    msp.GetSol(iSolutionId, out iSolutionIdStatus, dSol, i, i, out nValuesReturned);
                    Console.WriteLine(i + " = " + dSol[0]);
                }
            }

            XPRS.Free();
        }
    }
}
