# Example that shows how to treat an infeasible problem.
#
# (C) 1983-2025 Fair Isaac Corporation

import xpress as xp

minf = xp.problem("ex-infeas")

x0 = minf.addVariable()
x1 = minf.addVariable()
x2 = minf.addVariable(vartype=xp.binary)

c1 = x0 + 2 * x1 >= 1
c2 = 2 * x0 + x1 >= 1
c3 = x0 + x1 <= .5

minf.addConstraint(c1, c2, c3)
minf.optimize()
minf.IISAll()
print("there are ", minf.attributes.numiis, " iis's")


# Get data for the first IIS.
miisrow, miiscol, constrainttype, colbndtype, \
      duals, rdcs, isolationrows, isolationcols = minf.getIISData(1)

print("iis data:", miisrow, miiscol, constrainttype, colbndtype,
      duals, rdcs, isolationrows, isolationcols)

# Another way to check IIS isolations.
print("iis isolations:", minf.IISIsolations(1))

num_iis, rowsizes, colsizes, suminfeas, numinfeas = minf.IISStatus()

print("number iis's:", num_iis)
print("vectors:", rowsizes, colsizes, suminfeas, numinfeas)
